/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.common.exceptions.PIHscExceptionUtils;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.cmdhelpers.FspCecTime;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbem.provider.InstanceProvider;
import org.snia.wbem.provider.MethodProvider;

public class PICommonMethProv
implements MethodProvider {
    private ProviderCIMOMHandle mCIMOMHandle = null;
    private InstanceProvider mInstanceHandle = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        System.out.println("********************");
        System.out.println("In initialize...");
        this.mCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.mInstanceHandle = this.mCIMOMHandle.getInternalProvider();
        System.out.println("End of initialize");
        System.out.println("********************");
    }

    public void cleanup() throws CIMException {
        System.out.println("********************");
        System.out.println("In cleanup ... ");
        this.mInstanceHandle.cleanup();
        this.mInstanceHandle = null;
        this.mCIMOMHandle = null;
        System.out.println("End of cleanup");
        System.out.println("********************");
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        String string2;
        System.out.println("method name: " + string);
        int n = 0;
        if (string.equals("GetCecTime")) {
            string2 = this.getCecName(cIMObjectPath);
            OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string2);
            UnsignedInt64 unsignedInt64 = this.getCecTime(omCecMgr);
            CIMValue cIMValue = null;
            if (unsignedInt64 != null) {
                cIMValue = new CIMValue((Object)unsignedInt64, new CIMDataType(7));
            } else {
                n = 2;
            }
            vector2.setSize(1);
            vector2.setElementAt(new CIMProperty("CecTime", cIMValue), 0);
        } else if (string.equals("SetCecTime")) {
            string2 = this.getCecName(cIMObjectPath);
            OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string2);
            this.setCecTime(omCecMgr, vector);
        } else {
            n = 1;
        }
        System.out.println("PICommonMethProv:  methodRC = " + n);
        string2 = new UnsignedInt8((short)n);
        return new CIMValue((Object)string2, new CIMDataType(1));
    }

    private UnsignedInt64 getCecTime(OmCecMgr omCecMgr) {
        UnsignedInt64 unsignedInt64 = null;
        try {
            FspCecTime fspCecTime = omCecMgr.getCmdHelper().getCecTimeOfDay(omCecMgr.getCecName());
            long l = fspCecTime.getTimeInMillis();
            unsignedInt64 = new UnsignedInt64(String.valueOf(l));
            System.out.println("cecTime: " + fspCecTime.toString());
            System.out.println("cecTime=" + l);
        }
        catch (Throwable throwable) {
            System.out.println("cannot get cec time. return null to client.");
        }
        return unsignedInt64;
    }

    private void setCecTime(OmCecMgr omCecMgr, Vector vector) throws CIMException {
        try {
            int n = omCecMgr.getCecState();
            this.jdebug(" cec state = " + n + " expected state = " + 3);
            if (n != 3) {
                throw new PIHscServerException("022C");
            }
            if (vector == null || vector.size() == 0) {
                throw new PIHscServerException("01FC");
            }
            CIMValue cIMValue = ((CIMProperty)vector.elementAt(0)).getValue();
            Long l = new Long(((UnsignedInt64)cIMValue.getValue()).longValue());
            this.jdebug(".setCecTime -> FspCmdHelper.setCecTimeOfDay " + l);
            omCecMgr.getCmdHelper().setCecTimeOfDay(omCecMgr.getCecName(), l);
        }
        catch (PIHscServerException pIHscServerException) {
            System.err.println("setCecTimeOfDay failed");
            pIHscServerException.printStackTrace();
            throw new CIMException(PIHscExceptionUtils.mapID(pIHscServerException.getHscExId()), (Object)pIHscServerException.toString());
        }
    }

    private String getCecName(CIMObjectPath cIMObjectPath) {
        CIMProperty cIMProperty = null;
        String string = null;
        Vector vector = cIMObjectPath.getKeys();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            cIMProperty = (CIMProperty)vector.elementAt(i);
            if (!cIMProperty.getName().equals("Name")) continue;
            string = (String)cIMProperty.getValue().getValue();
            break;
        }
        return string;
    }

    private void jdebug(String string) {
        System.err.println("PICommonMethProv" + string);
    }
}

